'use client';

import React from 'react';
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';
import { YMaps } from '@pbe/react-yandex-maps';

export const queryClient = new QueryClient();

interface IProps {
  initials?: Array<{
    key: string[];
    data: any;
  }>;
}

const ReactQueryWrapper: React.FC<React.PropsWithChildren<IProps>> = ({ children, initials }) => {
  initials?.forEach((el) => {
    queryClient.setQueryData(el.key, el.data);
  });

  return (
    <QueryClientProvider client={queryClient}>
      <YMaps>{children}</YMaps>
    </QueryClientProvider>
  );
};

export default ReactQueryWrapper;
