'use client';

import React, { useEffect, useState } from 'react';
import ReactDOM from 'react-dom';

interface IProps {
  tag?: string;
  parent?: any;
}

const Portal: React.FC<React.PropsWithChildren<IProps>> = ({ tag = 'div', children, parent }) => {
  const [container] = useState(() => {
    return document.createElement(tag);
  });

  useEffect(() => {
    (parent || document.body).appendChild(container);
    return () => {
      if (container) {
        (parent || document.body).removeChild(container);
      }
    };
  }, [parent, container]);

  return ReactDOM.createPortal(children, container);
};

export default Portal;
