// eslint-disable-next-line no-restricted-imports
import { useCallback, useEffect, useMemo, useState } from 'react';
import classNames from 'classnames';
import Icon from '@/components/Icon';

interface IProps {
  onFullBlock: () => void;
  video: any;
}

const Player: React.FC<IProps> = ({ onFullBlock, video }) => {
  const [maxTime, setMaxTime] = useState(0);
  const [speed, setSpeed] = useState(0);
  const [currTime, setCurrTime] = useState(0);

  const handleStop = useCallback(() => {
    console.log(video);
    // console.log(    video.getVideoPlayTime(0))
    console.log(video.Qd(0));
  }, [video])

  const handleStart = useCallback(() => {
    console.log(video);
    console.log(video.Kd(0))
  }, [video])

  const handleSlow = useCallback(() => {
    console.log(video);
    video.$d(0)
  }, [video])

  const handleFast = useCallback(() => {
    console.log(video);
    console.log(video.tp(0))
  }, [video])

  const handleStep = useCallback(() => {
    console.log(video);
    console.log(video.ip(0))
  }, [video])

  const updTime = useCallback(() => {
    if(!video?.I0[0].eu) {
      setMaxTime(0)
      setCurrTime(0)
      setSpeed(0)
      return;
    }
    setMaxTime(video?.I0[0].eu.ks)
    setCurrTime(video?.I0[0].eu.Vo + video?.I0[0].eu.Go)
    setSpeed(video?.I0[0].eu.ko)
  }, [video])

  useEffect(() => {
    console.log(video)
    const int = setInterval(updTime, 100)

    return () => {
      clearInterval(int)
    }
  }, [updTime, video])

  const progress = useMemo(() => {
    return currTime/maxTime;
  }, [maxTime, currTime])

  const formatMaxTime = useMemo(() => {
    const secs = maxTime / 1000;

    const hours = Math.floor(secs/60/60).toString().padStart(2, '0')
    const mins = (Math.floor((secs/60)%60)).toString().padStart(2, '0')
    const sec = Math.floor(secs%60).toString().padStart(2, '0')

    return `${hours}:${mins}:${sec}`
  }, [maxTime])

  const formatCurrTime = useMemo(() => {
    const secs = currTime / 1000;

    const hours = Math.floor(secs/60/60).toString().padStart(2, '0')
    const mins = (Math.floor((secs/60)%60)).toString().padStart(2, '0')
    const sec = Math.floor(secs%60).toString().padStart(2, '0')

    return `${hours}:${mins}:${sec}`
  }, [currTime])

  const formatSpeed = useMemo(() => {
    const res = speed < 0 ? `1/${-speed}` : speed;
    return res === 0 ? 1 : res
  }, [speed])

  const handleMove = useCallback((e: MouseEvent) => {
    const el = e.currentTarget as HTMLDivElement;

    const pos = (e.clientX - el.getBoundingClientRect().left) / el.getBoundingClientRect().width;
    const tick = pos * maxTime;

    console.log(video?.I0[0].eu)
    if(video) {
      video.If("setpos", tick)
    }
  }, [maxTime])

  return (
    <div className={classNames('border-[1px] border-light_gray px-[22px] py-5 bg-white rounded-[0px_0px_12px_12px]', {
      'opacity-35': !video
    })}>
      <div className='flex items-center'>
        <button title='Начать просмотр' arial-label='Начать просмотр' className='mr-[19px]' onClick={handleStart}>
          <Icon src='/images/icons/icon-start-video.svg' className='w-6 h-6 text-primary' />
        </button>
        <button title='Пауза' arial-label='Пауза' className='mr-[19px]' onClick={handleStop}>
          <Icon src='/images/icons/icon-pause-video.svg' className='w-6 h-6 text-[#D6D7DB]' />
        </button>
        <button title='Перемотать' arial-label='Перемотать' className='mr-[19px]' onClick={handleStep}>
          <Icon src='/images/icons/icon-rewind.svg' className='w-6 h-6 text-[#D6D7DB]' />
        </button>

        <div className='flex items-center gap-[14px]'>
          <button onClick={handleSlow}>
            <Icon
              src='/images/icons/icon-minus-video-speed.svg'
              className='w-6 h-6 text-[#D6D7DB]'
            />
          </button>
          <p>{formatSpeed}x</p>
          <button onClick={handleFast}>
            <Icon
              src='/images/icons/icon-plus-video-speed.svg'
              className='w-6 h-6 text-[#D6D7DB]'
            />
          </button>
        </div>

        <div
          className='h-1 rounded-[3px] bg-[#0A0A0A0A]  relative w-full mr-[27px] ml-[32px]'
          onClick={handleMove as any}
        >
          <div
            className='bg-primary h-1 rounded-[3px] block'
            style={{
              width: `${progress*100}%`
            }}
          />
          <div
            className='absolute w-5 h-5 rounded-[50%] top-[-7px] bg-white border-[4px] border-primary -translate-x-1/2'
            style={{
              left: `${progress*100}%`
            }}
          />
        </div>

        <time className='text-text text-base'>{formatCurrTime}/{formatMaxTime}</time>
        <button title='open full' aria-label='open full' className='ml-7' onClick={onFullBlock}>
          <Icon src='/images/full-screen.svg' className='w-6 h-6 text-primary' />
        </button>
      </div>
    </div>
  );
};

export default Player;
