import clsx from 'clsx';
import { FC, ReactNode } from 'react';

interface PaperProps {
  className?: string;
  children: ReactNode;
}

export const Paper: FC<PaperProps> = ({ children, className }) => {
  return (
    <div
      className={clsx(
        className,
        'pt-[10px] pl-8 pb-5 pr-[11px] rounded-xl border-[#E6E9EE] bg-white',
      )}
    >
      {children}
    </div>
  );
};
