import { FC } from 'react';
import Icon from '@/components/Icon';

const operations = {
  watch: {
    icon: '/images/icons/icon-watch.svg',
    title: 'Подробно',
    actionName: 'onWatch',
  },
  key: {
    icon: '/images/icons/icon-key.svg',
    title: 'Изменить пароль',
    actionName: 'onKey',
  },
  copy: {
    icon: '/images/icons/icon-copy.svg',
    title: 'Копировать',
    actionName: 'onCopy',
  },
  edit: {
    icon: '/images/icons/icon-edit.svg',
    title: 'Редактировать',
    actionName: 'onEdit',
  },
  circleCheck: {
    icon: '/images/icons/icon-circle-check.svg',
    title: '?',
    actionName: 'onCircleCheck',
  },
  remove: {
    icon: '/images/icons/icon-trash.svg',
    title: 'Удалить',
    actionName: 'onRemove',
  },
} as const;

export type OperationKeys = (keyof typeof operations)[];
type Actions = (typeof operations)[keyof typeof operations]['actionName'];

interface OperationsProps {
  operationKeys: OperationKeys;
  actions?: Partial<Record<Actions, () => void>>;
}

const Operations: FC<OperationsProps> = ({ operationKeys, actions }) => {
  return (
    <div className='flex items-center gap-[15px] justify-center'>
      {operationKeys.map((operation) => {
        const operationData = operations[operation];
        return (
          <button
            key={operation}
            type='button'
            title={operationData?.title}
            aria-label={operationData?.title}
            onClick={actions?.[operationData.actionName]}
          >
            <Icon src={operationData.icon} className='text-primary w-5 h-5' />
          </button>
        );
      })}
    </div>
  );
};

export default Operations;
