/* eslint-disable react/display-name */
'use client';

import React, { forwardRef } from 'react';
import { Clusterer, Map as MapComponent, YMaps } from '@pbe/react-yandex-maps';
import clsx from 'clsx';
import { IMapState } from 'yandex-maps';

import SquareButton from '@/components/SquareButton';
import GridButton from '@/components/GridButton';
import Icon from '@/components/Icon';
import type { IBooleanField, ISelectField } from '@/components/GridButton/constants';
import { useFullWindowContext } from '@/contexts/FullWindowComponentContext';
import './Map.scss';

interface IProps {
  className?: string;
  state?: IMapState;
}

const data: Array<ISelectField | IBooleanField> = [
  {
    label: 'Обновлять GPS каждые',
    type: 'select',
    key: 'updateTime',
    defaultValue: '90_sec',
    property: [
      { label: '90 секунд', value: '90_sec' },
      { label: '60 секунд', value: '60_sec' },
      { label: '30 секунд', value: '30_sec' },
    ],
  },
  {
    label: 'Единица измерения скорости',
    type: 'select',
    key: 'unitOfSpeedMeasurement',
    defaultValue: 'miles',
    property: [
      { label: 'мор.мили/ч', value: 'miles' },
      { label: 'км/ч', value: 'kilometers' },
    ],
  },
  {
    label: 'Показать линии',
    type: 'boolean',
    key: 'showLine',
    defaultValue: 'yes',
    property: [
      { label: 'Да', value: 'yes' },
      { label: 'Нет', value: 'no' },
    ],
  },
  {
    label: 'Полная информация о водителе отображается на карте',
    type: 'boolean',
    key: 'fullInfoAboutDriver',
    defaultValue: 'yes',
    property: [
      { label: 'Да', value: 'yes' },
      { label: 'Нет', value: 'no' },
    ],
  },
];

export const Map = forwardRef<HTMLDivElement, React.PropsWithChildren<IProps>>(
  ({ className, children, state }, ref) => {
    const { handleToggleComponent } = useFullWindowContext();
    return (
      <div className={clsx('bg-cyan-600 overflow-hidden relative', className)} ref={ref}>
        <YMaps>
          <MapComponent
            state={state}
            defaultState={{
              center: [55.751574, 37.573856],
              zoom: 5,
            }}
            className='w-full h-full relative'
            modules={['templateLayoutFactory', 'util.defineClass']}
          >
            <div className='absolute top-0 left-0 flex items-center gap-3 z-10 p-4 '>
              <GridButton
                data={data}
                classes={{ wrapperButton: 'bg-[#FFFFFF1A] backdrop-blur-md', card: 'left-0' }}
              />
              <SquareButton
                classes={{
                  root: 'h-10 w-10 min-w-10 bg-[#FFFFFF1A] backdrop-blur-md',
                }}
                onClick={() =>
                  handleToggleComponent(
                    <Map className={className} ref={ref}>
                      {children}
                    </Map>,
                  )
                }
              >
                <Icon src='/images/full.svg' className='h-[24px] w-[24px] text-primary' />
              </SquareButton>
            </div>
            <Clusterer
              options={{
                preset: 'islands#invertedVioletClusterIcons',
                groupByCoordinates: false,
                clusterDisableClickZoom: true,
                clusterHideIconOnBalloonOpen: false,
                geoObjectHideIconOnBalloonOpen: false,
              }}
            >
              {children}
            </Clusterer>
          </MapComponent>
        </YMaps>
      </div>
    );
  },
);

export default Map;
