'use client';
import { usePathname } from 'next/navigation';
import Link from 'next/link';
import clsx from 'clsx';
import Icon from '@/components/Icon';
import { navItems } from './constants';

export const Navbar = () => {
  const pathname = usePathname();

  return (
    <nav className='flex items-center gap-5'>
      {navItems.map((navItem) => {
        const isActiveLink = pathname === navItem.link;
        return (
          <Link
            key={navItem.link}
            href={navItem.link}
            className={clsx(
              'flex items-center gap-[6px] p-[10px] rounded-lg transition-colors duration-300',
              isActiveLink ? 'bg-[#E3F6FE]' : 'bg-transparent',
            )}
          >
            <Icon
              src={navItem.icon}
              className={clsx(
                'w-6 h-6 transition-colors duration-300',
                isActiveLink ? 'text-[#2981B3]' : 'text-navColor',
              )}
            />
            <span className={clsx('text-base leading-[19px] text-navColor')}>{navItem.name}</span>
          </Link>
        );
      })}
    </nav>
  );
};
