import Link from 'next/link';
import { Container } from '@/components/UI/Container';
import Icon from '@/components/Icon';
import Image from '@/components/Image';
import { SettingsDropdown } from './SettingsDropdown';
import { Navbar } from './Navbar';

export const Header = () => {
  return (
    <header className='bg-white py-4 mb-7'>
      <Container className='flex items-center justify-between'>
        <div className='flex items-center gap-10'>
          <Link href='/'>
            <Image
              alt='logo'
              src='/images/logo.svg'
              className='w-[97px] h-[45px] min-w-[97px] min-h-[45px]'
            />
          </Link>
          <Navbar />
        </div>
        <div className='flex items-center gap-5'>
          <Link
            href='/notifications'
            className='w-9 h-9 rounded-[50%] flex items-center justify-center bg-[#F5F6FA]'
            aria-label='Уведомления'
            title='Уведомления'
          >
            <Icon src='/images/icons/icon-bell.svg' className='h-6 w-6 text-[#2981B3]' />
          </Link>
          <SettingsDropdown />
        </div>
      </Container>
    </header>
  );
};
