/* eslint-disable @next/next/no-img-element */

import React, { FC } from 'react';

import clsx from 'clsx';

interface IProps {
  src: string;
  alt: string;
  className?: string;
}

const Image: FC<IProps> = ({ src, alt, className }) => {
  return <img className={clsx(className, 'block')} alt={alt} src={src} />;
};

export default Image;
