/* eslint-disable @next/next/no-img-element */

import clsx from 'clsx';
import React, { FC } from 'react';

interface IProps {
  src: string;
  className?: string;
}

const Icon: FC<IProps> = ({ src, className }) => {
  return (
    <div
      className={clsx(className, 'block')}
      style={
        {
          maskImage: `url(${src})`,
          maskRepeat: 'no-repeat',
          WebkitMaskImage: `url(${src})`,
          WebkitMaskSize: 'contain',
          maskSize: 'contain',
          background: 'currentColor',
        } as any
      }
    />
  );
};

export default Icon;
