import React from 'react';

import type { IGridInfo } from './interfaces';

interface IProps {
  gridInfo: IGridInfo;
}

const GridLayout: React.FC<IProps> = ({
  gridInfo
}) => {
  return (
    <div className='flex flex-col'>
      {gridInfo.rows.map((row, rowindex) => (
          <div
            key={rowindex}
            className='flex gap-7'
          >
            {row.items.map((item, itemIndex) => (
              <div
                key={itemIndex}
                className='flex flex-col flex-1 bg-white border rounded'
              >
                <span className='mb-2'>
                  {item.title}
                </span>
              </div>
            ))}
          </div>
      ))}
    </div>
  );
};

export default GridLayout;