'use client';
import Cookies from 'js-cookie';
import classNames from 'classnames';
import React, { forwardRef, useMemo, useRef } from 'react';
import clsx from 'clsx';
import { IRecord } from '@/queries/records.interfaces';
import Video from './Video';

interface IProps {
  className?: string;
  type?: 'record' | 'stream';

  deviceID: string;
  chnID: number;

  record?: IRecord;
  onClick?: (video: any) => void;
  selectedVideo?: any;
}

const Camera = forwardRef<any, React.PropsWithChildren<IProps>>(
  ({ className, deviceID, chnID, type = 'stream', record, onClick, selectedVideo }, ref) => {
    const videoRef = useRef<any>(null);
    const JSESSIONID = useMemo(() => {
      return Cookies.get('JSESSIONID');
    }, []);

    console.log(selectedVideo);

    return (
      <div className={clsx(className, 'w-full h-full p-3 bg-black relative overflow-hidden')}>
        <div
          className={classNames('absolute top-0 left-0 w-full h-full z-10 pointer-events-none', {
            'border-[#2CA32A] border-2': videoRef.current === selectedVideo,
          })}
        />
        <div
          className='flex flex-col justify-between h-full pointer-events-auto'
          onClick={() => onClick?.(videoRef.current)}
        >
          <div className='absolute top-0 right-0 left-0 bottom-0'>
            <Video
              ref={videoRef}
              session={JSESSIONID!}
              devIDNO={deviceID}
              channel={chnID.toString()}
              type={type}
              record={record}
            />
          </div>
        </div>
      </div>
    );
  },
);

export default Camera;
