'use client';

import usePromise from "react-promise"

interface IProps<T> {
    promise?: Promise<T>;
    then: (res: T) => any;
    loading?: React.ReactNode;
    noValue?: React.ReactNode;
}


export const Async = <T extends object>({
    promise,
    then,
    loading,
    noValue
  }: IProps<T>) => {
    const { value, loading: isLoad } = usePromise<T>(promise || Promise.reject())
    if (isLoad) {
        return loading || null
    }

    if(!value) {
        return noValue || null
    }

    return <div>{then(value)}</div>
}