export interface IDevice {
    id: number;
    did: number;    // {name: 'id', data: 0},
    pid: number;    //  {name: 'parentId', data: 0},
    cc: number;     //  {name: 'chnCount', data: 0},
    ic: number;     //  {name: 'ioInCount', data: 0},
    outc: number;   //  {name: 'ioOutCount', data: 0},
    tc: number;     //  {name: 'tempCount', data: 0},
    us: number;     //  {name: 'useStatus', data: 0},
    isb: number;    //  {name: 'isSuBiao', data: 0},
    gps: number;    //  {name: 'no_analyze_gps', data: 0},
    fp: number;     //  {name: 'faceProtocol', data: 0},
    tkc: number;    //  {name: 'talkPhysicalChannel', data: 0},
    md: number;     //  {name: 'module', data: 0},
    dt: number;     //  {name: 'devType', data: 0},
    ptt: number;    //  {name: 'ptt', data: 0},
    nflt: number;   //  {name: 'flowLimitType', data: 0},
    cn: string;     //  {name: 'chnName', data: null},
    io: string;     // {name: 'ioInName', data: null},
    outn: string;   // {name: 'ioOutName', data: null},
    srl: string;    // {name: 'serial', data: null},
    sim: string;    // {name: 'simCard', data: null}
}

export class StandardDevice {
    private module: number;   //Peripheral parameters
    private id: number;
    private deviceID: number;

    constructor(info: IDevice) {
        this.module = info.md;
        this.id = info.id;
        this.deviceID = info.did;
    }

    getModule() {
        return this.module;
    };

    getID() {
        return this.id;
    }

    isVideoDevice() {
        if (this.module) {
            //Should afu be judged bitwise 150603
            var mod = Number(this.module);//.toString(2);
            if (((mod >> 0) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    };

    isGpsDevice() {
        if (this.isVideoDevice()) {
            return false;
        } else {
            return true;
        }
    };

    isTalkbackSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 8) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }


    isMonitorSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 6) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isAuxiliaryTankSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 17) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isOilControlSupport () {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 1) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isObdSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 9) & 1) > 0) {
                return true;
            }
        }
        return false;
    }

    isPeopleSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 10) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isElecControlSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 2) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isOilSensorSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 7) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isWaterLevelSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 16) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isWaterDepthSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 18) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isWeightSensorSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 15) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isTTSSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 3) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    hasTpms() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 11) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    isElectronicLockSupport() {
        if (this.module) {
            var mod = Number(this.module);
            if (((mod >> 19) & 1) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}