import { queryClient } from "@/components/ReactQueryWrapper/ReactQueryWrapper";
import { IGetUserVehicleExForIndexResponse } from "@/queries/records.interfaces";
import { IDevice, StandardDevice } from "./StandartDevice";

export interface IVehicle {
    pid: number;    // {name: 'parentId', data: 0},//Parent company id
    ic: number;     // {name: 'icon', data: 1},//vehicle icon
    vtp1: number;   // {name: 'vehicleType', data: 0},//Vehicle Type
    id: number;     // {name: 'vid', data: 0},//vehicle id
    st: number;     // {name: 'use', data: 0},//status of use
    ity: number;    // {name: 'ity', data: 0},//Install tire pressure
    iad: number;    // {name: 'iad', data: 0},//Install Adas
    ids: number;    // {name: 'ids', data: 0},//Install DSM
    ibs: number;    // {name: 'ibs', data: 0},//Install BSD
    icd: number;    // {name: 'icd', data: 0},//Installation and installation of lane change decision aid
    iom: number;    // {name: 'iom', data: 0},//Install all-in-one machine
    mc: number;     // {name: 'mileCoefficient', data: 0},//mileage factor
    lsp: number;    // {name: 'speedLimit', data: 0},//Speed ​​limit value of vehicle information
    pt: string;     // {name: 'plate', data: ""},//License plate color is only set for V6
    pth: string;    // {name: 'plateTypeH', data: ""},//License plate color is only set for V6
    vimg: string;   // {name: 'vimg', data: ""},//Vehicle photo | Police face photo V9 only set
    gps: string;    // {name: 'gpsDays', data: ""},//GPS retention days
    nm: string;     // {name: 'name', data: null},
    dn: string;     // {name: 'driverName', data: null},
    di: string;     // {name: 'driverImg', data: null},
    ctm: string;    // {name: 'customizeMenu', data: null},
    djb: string;    // {name: 'driverNum', data: null},
    dt: string;     // {name: 'driverTele', data: null},
    dc: string;     // {name: 'driverCode', data: null},
    abbr: string;   // {name: 'abbr', data: null},
    vtp: string;    // {name: 'vehiType', data: null},
    pvg: string;    // {name: 'privilege', data: null},
    lot: string;    // {name: 'linesOperation', data: null},
    etm: number;    // {name: 'timeEnd', data: 0},
    fam: string;    // {name: 'fam', data: null},//Frame number
    rm: string;     // {name: 'remark', data: null},

    dl: IDevice[];
}

export class StandardVehicle {
    private parentId: number;   //Peripheral parameters
    private icon: number;
    private vehicleType: number;
    private vid: number;
    private use: number;
    private ity: number;
    private iad: number;
    private ids: number;
    private ibs: number;
    private icd: number;
    private iom: number;
    private mileCoefficient: number;
    private speedLimit: number;
    private plate: string;
    private plateTypeH: string;
    private vimg: string;
    private gpsDays: string;
    private name: string;
    private driverName: string;
    private driverImg: string;
    private customizeMenu: string;
    private driverNum: string;
    private driverTele: string;
    private driverCode: string;
    private abbr: string;
    private vehiType: string;
    private privilege: string;
    private linesOperation: string;
    private timeEnd: number;
    private fam: string;
    private remark: string;

    private deviceList: StandardDevice[];

    constructor(info: IVehicle) {
        this.parentId = info.pid;
        this.icon = info.ic;
        this.vehicleType = info.vtp1;
        this.vid = info.id;
        this.use = info.st;
        this.ity = info.ity;
        this.iad = info.iad;
        this.ids = info.ids;
        this.ibs = info.ibs;
        this.icd = info.icd;
        this.iom = info.iom;
        this.mileCoefficient = info.mc;
        this.speedLimit = info.lsp;
        this.plate = info.pt;
        this.plateTypeH = info.pth;
        this.vimg = info.vimg;
        this.gpsDays = info.gps;
        this.name = info.nm;
        this.driverName = info.dn;
        this.driverImg = info.di;
        this.customizeMenu = info.ctm;
        this.driverNum = info.djb;
        this.driverTele = info.dt;
        this.driverCode = info.dc;
        this.abbr = info.abbr;
        this.vehiType = info.vtp;
        this.privilege = info.pvg;
        this.linesOperation = info.lot;
        this.timeEnd = info.pid;
        this.fam = info.fam;
        this.remark = info.rm;

        this.deviceList = info.dl.map((el) => new StandardDevice(el));
    }

    getID() {
        return this.vid;
    }

    getDevices() {
        return this.deviceList;
    }

    getParentID() {
        return this.parentId;
    }

    getName() {
        return this.name;
    }

    getFistDeviceID() {
        return this.deviceList[0].getID();
    }

    getCompanyName() {
        const indexData = queryClient.getQueryData(['GetUserVehicleExForIndex']) as IGetUserVehicleExForIndexResponse

        const group = indexData.infos.find((el) => el.id === this.parentId.toString());

        return indexData.infos.find((el) => el.id === group?.companyId.toString())?.name;
    }

    getGroupName() {
        const indexData = queryClient.getQueryData(['GetUserVehicleExForIndex']) as IGetUserVehicleExForIndexResponse
        return indexData.infos.find((el) => el.id === this.parentId.toString())?.name;
    }

    getGpsData() {
        const allData = queryClient.getQueryData(['statuses', 'list']) as Record<string, any>
        const vehData = allData[this.getFistDeviceID()];


        console.log(vehData);
        return vehData
    }

}