import type { Metadata } from 'next';
import localFont from 'next/font/local';
import ReactQueryWrapper from '@/components/ReactQueryWrapper';

import './globals.css';

const magistral = localFont({
  src: [
    { path: 'fonts/Magistral-Book.woff2', weight: '400' },
    { path: 'fonts/Magistral-Bold.woff2', weight: '700' },
    { path: 'fonts/Magistral-ExtraBold.woff2', weight: '900' },
  ],
  variable: '--font-magistral',
});

export const metadata: Metadata = {
  title: 'Create Next App',
  description: 'Generated by create next app',
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang='en'>
      <head>
        <script async src='/cmsv6player.min.js' type='text/javascript' />
      </head>
      <body className={magistral.className}>
        <ReactQueryWrapper>{children}</ReactQueryWrapper>
      </body>
    </html>
  );
}
