import type { FC, ReactNode } from 'react';
import { Container } from '@/components/UI/Container';
import StatisticsSidebar from '@/pagesComponents/Statistics/components/StatisticsSidebar';

const Layout: FC<{ children: ReactNode }> = ({ children }) => {
  return (
    <Container>
      <section className='grid grid-cols-[280px,calc(100%-310px)] gap-[30px]'>
        <StatisticsSidebar />
        {children}
      </section>
    </Container>
  );
};

export default Layout;
