'use client';
import { FC, ReactNode } from 'react';
import { usePathname } from 'next/navigation';
import { Container } from '@/components/UI/Container';
import Icon from '@/components/Icon';
import SettingsSidebar from './components/SettingsSidebar';
import { links } from './_constants';

const Layout: FC<{ children: ReactNode }> = ({ children }) => {
  const pathname = usePathname();

  const activePage = links.find((link) => link.link === pathname);

  return (
    <Container>
      <section className='grid grid-cols-[280px,calc(100%-310px)] gap-[30px]'>
        <SettingsSidebar />
        <div className='py-[21px] pl-[23px] pr-8 rounded-xl border border-light_gray bg-white'>
          {activePage && (
            <button
              type='button'
              className='pb-1 px-7 border-b-[2px] border-primary flex items-center gap-[6px] mb-6'
            >
              <span className='text-sm leading-4 text-center text-primary font-bold'>
                {activePage.name}
              </span>
              <span>
                <Icon src='/images/close.svg' className='w-4 h-4 text-primary' />
              </span>
            </button>
          )}
          {children}
        </div>
      </section>
    </Container>
  );
};

export default Layout;
