'use client';
import clsx from 'clsx';
import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { links } from '@/app/(dashboard)/settings/_constants';

const SettingsSidebar = () => {
  const pathname = usePathname();

  return (
    <aside className='rounded-xl p-6 border border-light_gray bg-white'>
      <ul className='flex flex-col gap-[30px]'>
        {links.map((link) => (
          <li
            key={link.link}
            className={clsx('text-base leading-5', {
              'text-text': pathname !== link.link,
              'text-primary': pathname === link.link,
            })}
          >
            <Link href={link.link}>{link.name}</Link>
          </li>
        ))}
      </ul>
    </aside>
  );
};

export default SettingsSidebar;
