'use client';
import { redirect } from 'next/navigation';
import Cookies from 'js-cookie';
import { useEffect } from 'react';
import { COOKIE_NAME } from '@/api/api';
import { Header } from '@/components/Layout/Header';

export default function DashboardLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  useEffect(() => {
    if (!Cookies.get(COOKIE_NAME)) {
      redirect('/login');
    }
  }, []);

  return (
    <>
      <Header />
      <main className='mb-11'>{children}</main>
    </>
  );
}
